package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.hero.objects.skills.Language;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class LanguageDialog extends SkillDialog {

	private static final long serialVersionUID = 7744678314925830578L;

	private JCheckBox nativeTongueCB;

	public LanguageDialog(Language skill, boolean isNew, boolean isPower) {
		super(skill, isNew, isPower);
		if (!skill.isNativeTongue()) {
			if (skill.nativeTongueSelected()) {
				nativeTongueCB.setVisible(false);
			}
		}
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridy = 82;
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weighty = 0;
		gbc.weightx = 0;
		panel.add(nativeTongueCB, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		updateValues();
		nativeTongueCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				((Language) object)
						.setNativeTongue(nativeTongueCB.isSelected());
				updateValues();
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		displayLbl.setText("Display:");
		displayTF.setColumns(6);
		optionsLbl.setText("Level:");
		nativeTongueCB = new JCheckBox("Native Tongue");
		nativeTongueCB.setSelected(((Language) object).isNativeTongue());
	}
}